#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include scripts\utility;
#include maps\mp\gametypes\_damage;
#include maps\mp\h2_killstreaks\_ac130;
#include maps\mp\h2_killstreaks\_nuke;
#include maps\mp\h2_killstreaks\_autosentry;

#define H2_AC130_HEALTH 			1000
#define H2_AC130_NUMBER_OF_FLARES 	2
#define H2_AC130_TIMEOUT			40
#define H2_AC130_CINEMATIC           0

init(){
    //replacefunc(maps\mp\perks\_perkfunctions::dofinalkillcamfx, ::oitc_dofinalkillcamfx);
    //Need to use to monitor fast tac if I ever set that up.

    precachemodel( "equip_iw4_throwingknife_npc" );
    replacefunc(maps\mp\gametypes\_weapons::throwingknifeusage, ::autoPickupThrowingKnife);
    
    replacefunc(maps\mp\h2_killstreaks\_nuke::doNuke, ::hz_doNuke);
    replacefunc(maps\mp\h2_killstreaks\_nuke::nukeEffects, ::hz_nukeEffects);
    replacefunc(maps\mp\h2_killstreaks\_nuke::nukeDeath, ::hz_nukeDeath);

    //replacefunc(maps\mp\h2_killstreaks\_autosentry::h2_sentry_initSentry, ::hz_h2_sentry_initSentry);
    replacefunc(maps\mp\h2_killstreaks\_autosentry::sentry_handleDeath, ::hz_sentry_handleDeath);
    replacefunc(maps\mp\h2_killstreaks\_autosentry::sentry_handleOwner, ::hz_sentry_handleOwner);
    replacefunc(maps\mp\h2_killstreaks\_autosentry::sentry_timeOut, ::hz_sentry_timeOut);

    replacefunc(maps\mp\h2_killstreaks\_ac130::init, ::hz_ac130_init);
    replacefunc(maps\mp\h2_killstreaks\_ac130::start_h2_ac130, ::hz_start_h2_ac130);
    replacefunc(maps\mp\h2_killstreaks\_ac130::exitAC130OnEntNotify, ::hz_exitAC130OnEntNotify);

    replacefunc(maps\mp\h2_killstreaks\_remotemissile::tryUsePredatorMissile, ::hz_tryUsePredatorMissile);
    replacefunc(maps\mp\h2_killstreaks\_remotemissile::_fire, ::hz_fire);

    replacefunc(maps\mp\gametypes\_damage::callback_playerdamage_internal, ::hz_callback_playerdamage_internal);
    replacefunc(maps\mp\gametypes\_damage::playerkilled_internal, ::hz_playerkilled_internal);

    replacefunc(maps\mp\gametypes\_menus::menugiveclass, ::hz_menugiveclass);
    //replacefunc(maps\mp\gametypes\_menus::beginclasschoice, ::beginclasschoice);

    //replacefunc(maps\mp\gametypes\_gamelogic::endgame, ::hz_endgame);

    level thread user_scripts\mp_patches\hawkins\init::init();
}

autoPickupThrowingKnife(){
	self endon("death");
	self endon("disconnect");

    if(!isDefined(self.zombieSkills["knife"]))
        self.zombieSkills["knife"] = false;

	for(;;){
		self waittill("grenade_fire", grenade, weaponName);
        if(isdefined(grenade) && weaponName == "iw9_throwknife_mp"){
            grenade thread waitForStick();
        }
	}
}

waitForStick(){
	self waittill("missile_stuck");
    oldOrigin = undefined;
	while(self.origin != oldOrigin){
        oldOrigin = self.origin;
        wait 1;
    }
	pos = self.origin;
	model = spawn( "script_model", pos );
	model setModel("equip_iw4_throwingknife_npc");
	model.angles = self.angles;
	trigger = spawn( "trigger_radius", pos-(0,0,45), 0, 30, 50 );
	trigger thread watchTimeout(model);
	self delete();
	while(isdefined(trigger))
	{
		trigger waittill( "trigger", player );
		if(Distance(pos, player getTagOrigin("j_head")) <= 75 && player hasWeapon("iw9_throwknife_mp") && player getammocount("iw9_throwknife_mp") == 0 && player.zombieSkills["knife"])
		{
			player setlethalweapon("iw9_throwknife_mp");
			player maps\mp\gametypes\_class::giveoffhand("iw9_throwknife_mp");
			player setWeaponAmmoClip("iw9_throwknife_mp", 1);
			player playLocalSound("h2_scavenger_pack_pickup");
			trigger notify("deleted");
			model delete();
			trigger delete();
		}
		wait 0.025;
	}
}

watchTimeout(model){
	self endon("deleted");
	wait 60;
	model delete();
	self delete();
}

hz_menugiveclass( var_0 )
{
    if(!self.deathWarning && self.team == "allies" && level.gameState == "playing"){
        self.deathWarning = true;
        self playLocalSound("UK_mp_cmd_fallback");
        self iPrintLnBold("^3Change classes again to come a ^1zombie!");
        self.readyToDie = true;
    }
    else if(level.gameState != "playing"){
        self iPrintLnBold("^3You can't change classes!");
        self.readyToDie = false;
    }
    else if(self.readyToDie && self.team == "allies"){
        self.pers["class"] = "class3";
		self.class = self.pers["class"];
        self _suicide();
    }
}

hz_fire( lifeId, owner )
{
	owner maps\mp\h2_killstreaks\_remotemissile::add_notify_commands();

	remote_missile_spawns = getentarray("remoteMissileSpawn", "targetname");

	foreach (spawn in remote_missile_spawns)
	{
		if (isdefined(spawn.target))
			spawn.targetent = getent(spawn.target, "targetname");	
	}

    iPrintlnBold("^1EXTREME Warning: ^3Zombie Predator Missle ^1INCOMING!");
    humanplayer = undefined;
	foreach(player in level.players)
	{	
		if(player.team == "allies" && player != owner){
            humanplayer = player;
        }
	}
    iPrintLn(humanplayer.name);
    upVector = (0, 0, level.missileRemoteLaunchVert );
    backDist = level.missileRemoteLaunchHorz;
    targetDist = level.missileRemoteLaunchTargetDist;

    forward = AnglesToForward( humanplayer.angles );
    startpos = humanplayer.origin + upVector + forward * backDist * -1;
    targetPos = humanplayer.origin + forward * targetDist;

	rocket = magicbullet("remotemissile_projectile_mp", startpos, targetPos, owner);
	if (!isdefined(rocket))
	{
		owner clearusingremote();
		return;
	}

	rocket.owner = owner;
	rocket thread maps\mp\h2_killstreaks\_remotemissile::handleDamage();

	rocket.lifeId = lifeId;
	rocket.type = "remote";

	maps\mp\h2_killstreaks\_remotemissile::missile_eyes(owner, rocket);
}

hz_tryUsePredatorMissile( lifeId )
{
	self setusingremote( "remotemissile" );
	level thread maps\mp\h2_killstreaks\_remotemissile::_fire( lifeId, self );
    return true;
}

hz_nukeDeath()
{
	level endon ( "nuke_cancelled" );

	level notify( "nuke_death" );

	maps\mp\gametypes\_hostmigration::waitTillHostMigrationDone();

	AmbientStop(1);

	foreach( player in level.players )
	{
		if ( isAlive( player ) && player.team == "axis" || isAlive( player ) && !player.exfilLeaving)
			player thread maps\mp\gametypes\_damage::finishPlayerDamageWrapper( level.nukeInfo.player, level.nukeInfo.player, 999999, 0, "MOD_EXPLOSIVE", "nuke_mp", player.origin, player.origin, "none", 0, 0 );
	}

	level.postRoundTime = 10;

	nukeEndsGame = true;

	if ( level.teamBased )
		thread maps\mp\gametypes\_gamelogic::endGame( level.nukeInfo.team, game["strings"]["nuclear_strike"], true );
	else
	{
		if ( isDefined( level.nukeInfo.player ) )
			thread maps\mp\gametypes\_gamelogic::endGame( level.nukeInfo.player, game["strings"]["nuclear_strike"], true );
		else
			thread maps\mp\gametypes\_gamelogic::endGame( level.nukeInfo, game["strings"]["nuclear_strike"], true );
	}
}

hz_nukeEffects()
{
	level endon ( "nuke_cancelled" );

	level.nukeCountdownTimer destroy();
	level.nukeCountdownIcon destroy();

	setGameEndTime( 0 );

	level.nukeDetonated = true;
	//level maps\mp\h2_killstreaks\_emp::destroyActiveVehicles( level.nukeInfo.player );

	foreach( player in level.players )
	{
		playerForward = anglestoforward( player.angles );
		playerForward = ( playerForward[0], playerForward[1], 0 );
		playerForward = VectorNormalize( playerForward );

		nukeDistance = 5000;
		/# nukeDistance = getDvarInt( "scr_nukeDistance" );	#/

			nukeEnt = Spawn( "script_model", player.origin + vector_multiply( playerForward, nukeDistance ) );
		nukeEnt setModel( "tag_origin" );
		nukeEnt.angles = ( 0, (player.angles[1] + 180), 90 );

		/#
			if ( getDvarInt( "scr_nukeDebugPosition" ) )
			{
				lineTop = ( nukeEnt.origin[0], nukeEnt.origin[1], (nukeEnt.origin[2] + 500) );
				thread draw_line_for_time( nukeEnt.origin, lineTop, ( 1, 0, 0 ), 10 );
			}
#/

		nukeEnt thread nukeEffect( player );
		player.nuked = true;
	}
}

hz_doNuke( allowCancel )
{
	level endon ( "nuke_cancelled" );

	level.nukeInfo = spawnStruct();
	level.nukeInfo.player = self;
	level.nukeInfo.team = self.pers["team"];
	level.nukeinfo.xpscalar = 1;

	level.nukeIncoming = true;

	maps\mp\gametypes\_gamelogic::pauseTimer();
	level.timeLimitOverride = true;

	if(level.dev)
		level.nukeTimer = 20;

	setGameEndTime( int( gettime() + (level.nukeTimer * 1000) ) );

	h2_nukeCountdown();

	if ( level.teambased )
	{
		thread teamPlayerCardSplash( "callout_used_nuke", self, self.team );
		/*
		players = level.players;

		foreach( player in level.players )
		{
		playerteam = player.pers["team"];
		if ( isdefined( playerteam ) )
		{
		if ( playerteam == self.pers["team"] )
		player iprintln( &"MP_TACTICAL_NUKE_CALLED", self );
		}
		}
		*/
	}
	else
	{
		if ( !level.hardcoreMode )
			self iprintlnbold( &"LUA_KS_TNUKE" );
	}



	level thread delaythread_nuke( (level.nukeTimer - 3.3), ::nukeSoundIncoming );
	level thread delaythread_nuke( level.nukeTimer, ::nukeSoundExplosion );
	level thread delaythread_nuke( level.nukeTimer, ::nukeSlowMo );
	level thread delaythread_nuke( level.nukeTimer, ::nukeEffects );
	level thread delaythread_nuke( (level.nukeTimer + 0.25), ::nukeVision );
	level thread delaythread_nuke( (level.nukeTimer + 1.5), ::nukeDeath );
	level thread delaythread_nuke( (level.nukeTimer + 1.5), ::nukeEarthquake );
	level thread nukeAftermathEffect();

	//if ( level.cancelMode && allowCancel )
	level thread cancelNukeOnDeath( self ); 

	// leaks if lots of nukes are called due to endon above.
	clockObject = spawn( "script_origin", (0,0,0) );
	clockObject hide();

	level.soundTimer = level.nukeTimer;

	while ( level.soundTimer > -20 )
	{
		//iPrintLn(level.soundTimer);
		if(level.soundTimer == 2)
			level notify("nuke_incoming");
		if(level.soundTimer == 20){
			foreach(player in level.players){
				if(player.team == "allies"){
					player thread startExfilHeli();
				}
			}
		}
			
		if(level.soundTimer == 15 || level.soundTimer == 25 || level.soundTimer == 20 || level.soundTimer == 30 || level.soundTimer == 40 || level.soundTimer == 50 || level.soundTimer == 60){
			clockObject playSound( "h2_nuke_timer" );
			wait 1;
		}
		else if(level.soundTimer < 15 && level.soundTimer >= 6){
			clockObject playSound( "h2_nuke_timer" );
			wait 1;
		}
		else if(level.soundTimer < 6 && level.soundTimer > -5){
			clockObject playSound( "h2_nuke_timer" );
			wait 0.5;
		}
		else if(level.soundTimer <= -5 && level.soundTimer > -15){
			clockObject playSound( "h2_nuke_timer" );
			wait 0.075;
		}
		else if(level.soundTimer <= -15){
			clockObject playSound( "h2_nuke_timer" );
			wait 0.05;
		}
		else{
			wait 1;
		}
		level.soundTimer--;
	}
}

destroyForDeath(chopper){
	self waittill("death");
	self.heliHint destroy();
	chopper delete();
}

destroyOnNuke(owner){
	self.heliExploded = false;
	level waittill_any("nuke_cancelled", "nuke_incoming");
	self.heliExploded = true;
	wait 2;
	if(!owner.exfilLeaving){
		radiusDamage( self.origin, 1, 5000, 5000, undefined );
		owner playlocalsound("UK_mp_cmd_fallback");
		owner.heliHint destroy();
	}
}

setSafeText(text)
{
	if(self.oldText != text)
	{
		self.oldText = text;
		self setText(text);
	}
}

showHeliHint(chopper)
{
	self.heliHint = createFontString( "objective", 1 );
	self.heliHint setPoint("BOTTOMCENTER", "BOTTOMCENTER", 0, -130);
	while(isAlive(self) && !level.nukeDetonated && isDefined(chopper) && !self.heliExploded){
		if(distance(self.origin, chopper.origin) < 260){
			self.heliHint setSafeText("^3Press [{+activate}] To Exfil!");
			if(self useButtonPressed()){
				chopper setCanDamage( false );
				break;
			}
				
		}
		else{
			self.heliHint setSafeText("");
		}
		wait 0.025;
	}
	self.heliHint destroy();
}

startExfilHeli(){

	dropSite = self.origin;
	dropYaw = randomFloat( 360 );
	heightAdjustment = undefined;
	flyHeight = self maps\mp\h2_killstreaks\_airdrop::getFlyHeightOffset( dropSite );
	if ( !isDefined(heightAdjustment) )
		heightAdjustment = 0;

	//flyHeight = self.origin[2]+300;
	flyHeight += heightAdjustment;

	pathGoal = dropSite * (1,1,0) +  (0,0,flyHeight);	
	pathStart = maps\mp\h2_killstreaks\_airdrop::getPathStart( pathGoal, dropYaw );
	pathEnd = maps\mp\h2_killstreaks\_airdrop::getPathEnd( pathGoal, dropYaw );		

	pathGoal = pathGoal + vector_multiply( anglestoforward( (0,dropYaw,0) ), -50 );

	chopper = maps\mp\h2_killstreaks\_airdrop::heliSetup( self, pathStart, pathGoal );

	self thread destroyForDeath(chopper);

	chopper thread destroyOnNuke(self);

	chopper endon( "death" );
	assert ( isDefined( chopper ) );

	chopper setVehGoalPos( pathGoal, 1 );
	wait ( 2 );

	chopper Vehicle_SetSpeed( 75, 40 );
	chopper SetYawSpeed( 180, 180, 180, .3 );

	chopper waittill ( "goal" );

	wait( .10 );
	chopper setvehgoalpos( (self.origin[0],self.origin[1],self.origin[2]+250), 1 );
	//chopper waittill ( "goal" );

	self.exfilLeaving = false;

	self showHeliHint(chopper);

	self.exfilLeaving = true;

	self.heliHint destroy();

	//self linkTo(chopper,"tag_minigun_attach_left",(0,0,0),(0,0,0)); 
	pass = spawn( "script_origin", self.origin+(0,0,50) );
	pass LinkTo( chopper, "tag_driver",(0,0,-30),(0,0,0) );
	self playerLinkTo(pass);

	chopper setvehgoalpos( (self.origin[0],self.origin[1],self.origin[2]+1500), 1 );
	chopper waittill ( "goal" );

	chopper setvehgoalpos( pathEnd, 1 );
	chopper Vehicle_SetSpeed( 75, 40 );
	//chopper.leaving = true;
	//chopper waittill ( "goal" );
	//chopper notify( "leaving" );
	//chopper maps\mp\h2_killstreaks\_airdrop::trimActiveBirdList();
	//maps\mp\h2_killstreaks\_airdrop::decrementLittleBirdCount();
	//chopper notify( "delete" );
	//chopper delete();
}

hz_sentry_handleOwner()
{
	self endon ( "death" );
	level endon ( "game_ended" );

	self notify ( "sentry_handleOwner" );
	self endon ( "sentry_handleOwner" );

	while(isDefined(self)){
		self.owner waittill_any( "disconnect", "joined_team", "joined_spectators" );

		//self notify( "death" );
		wait 3;
		foreach(player in level.players){
			if(player.team == "allies"){
				self.owner = player;
				self SetSentryOwner( player );
			}
		}
	}
}

hz_sentry_handleDeath(owner)
{
	entNum = self GetEntityNumber();

	self addToTurretList( entNum );

    iPrintLn("^4Owner: "+ self.owner.name);

	self waittill ( "death" );
    
	self.owner.SZ = 0;

	self laseroff();

	self removeFromTurretList( entNum );
	// this handles cases of deletion
	if ( !isDefined( self ) )
		return;

	self setModel( level.sentrySettings[ self.sentryType ].modelDestroyed );

	self sentry_setInactive();
	self setDefaultDropPitch( 40 );
	self SetSentryOwner( undefined );
	self SetTurretMinimapVisible( false );

	self playSound( "sentry_explode" );
	playFxOnTag( getFx( "sentry_explode_mp" ), self, "tag_aim" );

	wait ( 5 );

	if( !isDefined( self ) )
		return;

	self playSound( "sentry_explode_smoke" );

	playFx( getFx( "sentry_smoke_mp" ), self getTagOrigin( "tag_aim" ) );

	self delete();
}

hz_sentry_timeOut()
{
	
}

hz_h2_sentry_initSentry( sentryType, owner )
{
	self.sentryType = sentryType;

	self setModel( level.sentrySettings[ self.sentryType ].modelBase );
	self.health = 1000;

	self setCanDamage( true );
	self makeTurretInoperable();
	owner thread maps\mp\gametypes\_weapons::updateHudOutline( self );

	self setTurretModeChangeWait( true );
	//	self setConvergenceTime( .25, "pitch" );
	//	self setConvergenceTime( .25, "yaw" );
	self sentry_setInactive();
	self setDefaultDropPitch( -89.0 );	// setting this mainly prevents Turret_RestoreDefaultDropPitch() from running

	self sentry_setOwner( owner );
	self thread sentry_handleOwner();
	self thread sentry_handleDamage();
	self thread sentry_handleDeath(owner);
	self thread sentry_handleUse();
	//self thread sentry_timeOut();
	self thread sentry_attackTargets();
	self thread sentry_beepSounds();
}

hz_exitAC130OnEntNotify(ent, waitfor)
{
	self endon("leave_ac130");
	ent waittill( waitfor );

	self.isUsingAC130 = false;

	if ( waitfor != "death" )
		level.ac130 thread fly_away();

	level.ac130InUse = false;
	level.ac130player = undefined;

	if( isDefined( level.ac130.playerView ) )
		level.ac130.playerView delete();

	if( isDefined( level.ac130.plane ) )
		level.ac130.plane delete();

	if( isDefined( level.ac130.soundEnt ) )
		level.ac130.soundEnt delete();

	self thread exitAC130(waitfor == "disconnect");
}

hz_start_h2_ac130(lifeID)
{
	self endon ( "disconnect" );
	self endon ( "leave_ac130" );

	thread teamPlayerCardSplash( "callout_used_ac130", self );

	self.ac130LifeID = lifeID;
	level.ac130player = self;

	angle = randomInt( 360 );
	radiusOffset = randomInt( 2000 ) + 5000;

	xOffset = cos( angle ) * radiusOffset;
	yOffset = sin( angle ) * radiusOffset;
	zOffset = 3000;

	angleVector = vectorNormalize( (xOffset,yOffset,zOffset) );
	angleVector = vector_multiply( angleVector, 6000 );

	ac130 = spawn( "script_model", level.UAVRig.origin + angleVector );
	ac130.angles = (0, angle, 0);
	ac130 setModel( "vehicle_ac130_coop" );
	ac130 setCanDamage( true );
	ac130.numFlares = H2_AC130_NUMBER_OF_FLARES;
	ac130.owner = self;
	ac130.team = self.team;
	ac130.lifeId = lifeId;
	ac130 playLoopSound( "h2_veh_ac130_ext_dist" );
	ac130.lifeSpan = getDvarInt( "scr_ac130_timeout" );
	ac130 thread ac130_damage_tracker();
	ac130 thread handleIncomingStinger();
	ac130 thread playAC130Effects();

	level.ac130 = ac130;
	level.ac130.planemodel = ac130;

	level.UAVRig moveTo(self.origin, 0.1);//Moves AC130 to where player is for Hawkins Zombies

	self _visionsetnakedforplayer( "black_bw", 0 );
	self _visionsetnakedforplayer( "", 1 );

	if( self getCurrentWeapon() != "ac130_mp" || self isSwitchingWeapon() ) //force switching back to the laptop to keep the FOV
		self setSpawnWeapon("ac130_mp");

	self _disableWeaponSwitch();

	if ( getDvarInt( "camera_thirdPerson" ) )
		self setThirdPersonDOF( false );

	self thread exitAC130OnEntNotify(level.ac130, "death");
	self thread exitAC130OnEntNotify(level, "game_ended");
	self thread exitAC130OnEntNotify(self, "disconnect");
	self thread exitAC130OnEntNotify(self, "spawned");
	self thread exitAC130OnEntNotify(self, "joined_team");
	self thread exitAC130OnEntNotify(self, "ac130_timeout");

	ac130.playerView = spawn( "script_model", ac130 localToWorldCoords( (-600, 0, 50) ) );
	ac130.playerView setModel( "tag_origin" );
	ac130.playerView.angles = ac130.angles;

	if( H2_AC130_CINEMATIC )
	{
		ac130 hide();
		ac130 showToPlayer( self );
		self playerLinkWeaponviewToDelta( ac130.playerView, "tag_player", 1.0, 0, 0, 0, 0, true );

		wait 0.5;

		ac130.playerView moveTo( ac130 localToWorldCoords( (0, 500, 50) ), 2 );
		ac130.playerView rotateTo( ac130.angles + (0,-90,0), 2 );

		wait 2;

		ac130.playerView moveTo( ac130 localToWorldCoords( (0, 0, 50) ), 1 );

		wait 1;

		self _visionsetnakedforplayer( "end_game2", 0 );
		self _visionsetnakedforplayer( "", 1 );
		self unlink();

		ac130 show();
	}

	ac130 linkTo( level.UAVRig, "tag_origin", angleVector, (0, angle, 0) );
	ac130.playerView linkTo( ac130, "tag_origin", (0, 0, 0), (0, 180, 0) );

	wait 0.05;

	loopNode = level.heli_loop_nodes[ randomInt( level.heli_loop_nodes.size ) ];

	self PlayerLinkWeaponviewToDelta( ac130.playerView, "tag_player", 1.0, 90, 90, 0, 60 );
	self setPlayerAngles( (0, vectorToAngles( loopNode.origin - ac130.origin )[1], 0) );
	self playLoopSound( "h2_veh_ac130_ext_dist" );
	self setClientOmnvar( "ui_ac130_enabled", 1 );
	self thread customOverlay();
	self thread monitorLargeFire( "ac130_105mm_mp" );
	self thread monitorSmallFire( "ac130_40mm_mp" );
	self thread monitorSmallFire( "ac130_25mm_mp" );
	self thread ac130_25mm_sound();
	self thread monitorWeaponSwitch();
	self thread ac130Reload();
	self thread maps\mp\h2_killstreaks\_common::thermalVision( self, "leave_ac130" );
	//self thread weaponLockThink( ac130 );

	ac130.plane = spawnPlane( self, "script_model", level.UAVRig getTagOrigin( "tag_origin" ), "h2_objpoint_ac130_friendly", "h2_objpoint_ac130_enemy" );
	ac130.plane setModel( "tag_origin" );
	ac130.plane setContents( 0 );
	ac130.plane linkTo( ac130, "tag_origin", (0, 0, 0), (0, -90, 0) );

	if( isBot( self ) )
		self thread scripts\mp\bot_patches::bot_remote_use( ac130 );

	self ThermalVisionFOFOverlayOn();

	maps\mp\gametypes\_hostmigration::waitLongDurationWithHostMigrationPause( ac130.lifeSpan - 1 );
	self notify ( "ac130_timeout" );
}

hz_ac130_init()
{
	create_dvar( "scr_ac130_timeout", H2_AC130_TIMEOUT );

	level.ac130InUse = false;

	precacheModel( "vehicle_ac130_coop" );

	//precacheItem("ac130_25mm_mp");
	//precacheItem("ac130_40mm_mp");
	//precacheItem("ac130_105mm_mp");

	PrecacheMiniMapIcon( "h2_objpoint_ac130_friendly" );
	PrecacheMiniMapIcon( "h2_objpoint_ac130_enemy" );

	precacheShader( "h2_ac130_overlay_105mm" );
	precacheShader( "h2_ac130_overlay_40mm" );
	precacheShader( "h2_ac130_overlay_25mm" );

	level._effect[ "h2_ac130_flare" ] = loadfx( "fx/misc/flares_cobra" );

	level.killStreakFuncs["ac130_mp"] = ::tryUseAC130;
}

hz_callback_playerdamage_internal( var_0,      var_1,     var_2,   var_3,   var_4,   var_5,         var_6,   var_7,  var_8, var_9, var_10 )
{
                               //eInflictor, eAttacker, victim, iDamage, iDFlags, sMeansOfDeath, sWeapon, vPoint, vDir, sHitLoc, psOffsetTime
    if ( getdvarint( "virtuallobbyactive", 0 ) )
        return "virtuallobbyactive";
	
	if(var_1.zombieSkills["flame"] && var_6 == "zombiehands_mp"){
		var_3 = (250*50/(distance(var_1.origin,var_2.origin)+250));
	}
		
	if(var_1.zombieSkills["radio"] && var_6 == "zombiehands_mp")
		var_3 = 51;

    //iPrintLn(var_5);

	if(var_1 == var_2 && (issubstr( var_5, "MOD_EXPLOSIVE" ) || issubstr( var_5, "MOD_PROJECTILE" )))
		var_3 = 0;

	if(getdvarint("dev_mode") == 1){
        iprintln("iDamage: "+var_3);
        iprintln("sWeapon: "+var_6);
    }
		

    var_1 = maps\mp\_utility::_validateattacker( var_1 );
    var_11 = maps\mp\_utility::strip_suffix( var_6, "_lefthand" );

    if ( isdefined( var_5 ) && var_5 == "MOD_CRUSH" && isdefined( var_0 ) && isdefined( var_0.classname ) && var_0.classname == "script_vehicle" )
        return "crushed";

    if ( !maps\mp\_utility::isreallyalive( var_2 ) && !isdefined( var_2.inliveplayerkillstreak ) )
        return "!isReallyAlive( victim )";

    if ( isdefined( var_1 ) && var_1.classname == "script_origin" && isdefined( var_1.type ) && var_1.type == "soft_landing" )
        return "soft_landing";

    if( isDefined( var_5 ) && var_5 == "MOD_FALLING" && isDefined( var_2 ) && var_2 maps\mp\_utility::_hasPerk( "specialty_falldamage" ) ) //commando pro perk
        return "soft_landing";

    if ( var_2 ishardwrireprotected( var_6 ) )
        return "specialty_stun_resistance";

    if ( isdefined( level.hostmigrationtimer ) )
        return "level.hostMigrationTimer";

    if ( var_5 == "MOD_FALLING" )
        var_2 thread emitfalldamage( var_3 );

    if ( var_5 == "MOD_EXPLOSIVE_BULLET" && var_3 != 1 )
    {
        var_3 *= getdvarfloat( "scr_explBulletMod" );
        var_3 = int( var_3 );
    }

    if ( isdefined( var_1 ) && var_1.classname == "worldspawn" )
        var_1 = undefined;

    if ( isdefined( var_1 ) && isdefined( var_1.gunner ) )
        var_1 = var_1.gunner;

    var_12 = maps\mp\_utility::attackerishittingteam( var_2, var_1 );
    var_13 = isdefined( var_1 ) && isdefined( var_0 ) && isdefined( var_2 ) && isplayer( var_1 ) && var_1 == var_0 && var_1 == var_2 && !isdefined( var_0.poison );

    if ( var_13 )
        return "attackerIsInflictorVictim";

    var_14 = 0.0;

    if ( var_4 & level.idflags_stun )
    {
        var_14 = 0.0;
        var_3 = 0.0;
    }
    else if ( var_9 == "shield" )
    {
        if ( var_12 && level.friendlyfire == 0 )
            return "attackerIsHittingTeammate";

        if ( var_5 == "MOD_PISTOL_BULLET" || var_5 == "MOD_RIFLE_BULLET" || var_5 == "MOD_EXPLOSIVE_BULLET" && !var_12 )
        {
            if ( isplayer( var_1 ) )
            {
                var_1.lastattackedshieldplayer = var_2;
                var_1.lastattackedshieldtime = gettime();
            }

            if ( maps\mp\_utility::isenvironmentweapon( var_6 ) )
                var_16 = 25;
            else
                var_16 = maps\mp\perks\_perks::cac_modified_damage( var_2, var_1, var_3, var_5, var_6, var_7, var_8, var_9 );

            var_2.shielddamage += var_16;

            if ( !maps\mp\_utility::isenvironmentweapon( var_6 ) || common_scripts\utility::cointoss() )
                var_2.shieldbullethits++;

            if ( var_2.shieldbullethits >= level.riotshieldxpbullets )
            {
                var_2.shielddamage = 0;
                var_2.shieldbullethits = 0;
            }
        }

        if ( var_4 & level.idflags_shield_explosive_impact )
        {
            var_9 = "none";

            if ( !( var_4 & level.idflags_shield_explosive_impact_huge ) )
                var_3 *= 0.0;
        }
        else if ( var_4 & level.idflags_shield_explosive_splash )
        {
            if ( isdefined( var_0 ) && isdefined( var_0.stuckenemyentity ) && var_0.stuckenemyentity == var_2 )
                var_3 = 51;

            var_9 = "none";
        }
        else
            return "hit shield";
    }
    else if ( maps\mp\_utility::ismeleemod( var_5 ) && issubstr( var_6, "riotshield" ) )
    {
        if ( !( var_12 && level.friendlyfire == 0 ) )
        {
            var_14 = 0.0;
            var_2 stunplayer( 0.0 );
        }
    }

    if ( !issubstr(var_5, "MOD_IMPACT") && !var_12 )
        var_3 = maps\mp\perks\_perks::cac_modified_damage( var_2, var_1, var_3, var_5, var_6, var_7, var_8, var_9 );

    if ( isdefined( level.modifyplayerdamage ) )
        var_3 = [[ level.modifyplayerdamage ]]( var_2, var_1, var_3, var_5, var_6, var_7, var_8, var_9 );

    var_17 = isdefined( var_1 ) && !isdefined( var_1.gunner ) && ( var_1.classname == "script_vehicle" || var_1.classname == "misc_turret" || var_1.classname == "script_model" );
    var_12 = maps\mp\_utility::attackerishittingteam( var_2, var_1 );

    if ( !var_3 )
        return "!iDamage";

    var_2.idflags = var_4;
    var_2.idflagstime = gettime();

    if ( game["state"] == "postgame" )
        return "game[ state ] == postgame";

    if ( var_2.sessionteam == "spectator" )
        return "victim.sessionteam == spectator";

    if ( isdefined( var_2.candocombat ) && !var_2.candocombat )
        return "!victim.canDoCombat";

    if ( isdefined( var_1 ) && isplayer( var_1 ) && isdefined( var_1.candocombat ) && !var_1.candocombat )
        return "!eAttacker.canDoCombat";

    if ( isdefined( var_1 ) && isalive( var_1 ) && !isdefined( var_1.perkoutlined ) )
        var_1.perkoutlined = 0;

    if ( var_17 && var_12 )
    {
        /*if ( var_5 == "MOD_CRUSH" )
        {
            var_2 maps\mp\_utility::_suicide();
            return "suicide crush";
        }*/

        if ( !level.friendlyfire )
            return "!level.friendlyfire";
    }

    if ( isai( self ) )
        self [[ level.bot_funcs["on_damaged"] ]]( var_1, var_3, var_5, var_6, var_0, var_9 );

    if ( !isdefined( var_8 ) )
        var_4 |= level.idflags_no_knockback;

    var_18 = 0;

    if ( var_2.health == var_2.maxhealth && ( !isdefined( var_2.laststand ) || !var_2.laststand ) || !isdefined( var_2.attackers ) && !isdefined( var_2.laststand ) )
    {
        var_2.attackers = [];
        var_2.attackerdata = [];
    }

    if ( maps\mp\_utility::isheadshot( var_6, var_9, var_5, var_1 ) )
        var_5 = "MOD_HEAD_SHOT";

    if ( maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "onlyheadshots" ) )
    {
        if ( var_5 == "MOD_PISTOL_BULLET" || var_5 == "MOD_RIFLE_BULLET" || var_5 == "MOD_EXPLOSIVE_BULLET" || var_5 == "MOD_IMPACT" )
            return "getTweakableValue( game, onlyheadshots )";
        else if ( var_5 == "MOD_HEAD_SHOT" )
        {
            if ( var_2 maps\mp\_utility::isjuggernaut() )
                var_3 = 75;
            else
                var_3 = 150;
        }
    }

    if ( var_6 == "none" && isdefined( var_0 ) )
    {
        if ( isdefined( var_0.destructible_type ) && issubstr( var_0.destructible_type, "vehicle_" ) )
            var_6 = "destructible_car";
    }

    if ( var_6 == "destructible_toy" && isdefined( var_0 ) )
    {
        var_19 = var_0 getscriptabletypeforentity();

        if ( issubstr( var_19, "destpv_" ) )
            var_6 = "destructible_car";
    }

    if ( gettime() < var_2.spawntime + level.killstreakspawnshield )
    {
        var_20 = int( max( var_2.health / 4, 1 ) );

        if ( var_3 >= var_20 && maps\mp\_utility::iskillstreakweapon( var_6 ) && !maps\mp\_utility::ismeleemod( var_5 ) )
            var_3 = var_20;
    }

    if ( !( var_4 & level.idflags_no_protection ) )
    {
        if ( !level.teambased && var_17 && isdefined( var_1.owner ) && var_1.owner == var_2 )
        {
            //if ( var_5 == "MOD_CRUSH" )
            //    var_2 maps\mp\_utility::_suicide();

            return "ffa suicide";
        }

        if ( ( issubstr( var_5, "MOD_GRENADE" ) || issubstr( var_5, "MOD_EXPLOSIVE" ) || issubstr( var_5, "MOD_PROJECTILE" ) ) && isdefined( var_0 ) && isdefined( var_1 ) )
        {
            if ( var_2 != var_1 && var_0.classname == "grenade" && var_2.lastspawntime + 3500 > gettime() && isdefined( var_2.lastspawnpoint ) && distance( var_0.origin, var_2.lastspawnpoint.origin ) < 250 )
                return "spawnkill grenade protection";

            if ( var_2 victimcanupdatefinalattackerdata( var_1 ) )
            {
                var_2.explosiveinfo = [];
                var_2.explosiveinfo["damageTime"] = gettime();
                var_2.explosiveinfo["damageId"] = var_0 getentitynumber();
                var_2.explosiveinfo["returnToSender"] = 0;
                var_2.explosiveinfo["counterKill"] = 0;
                var_2.explosiveinfo["chainKill"] = 0;
                var_2.explosiveinfo["cookedKill"] = 0;
                var_2.explosiveinfo["throwbackKill"] = 0;
                var_2.explosiveinfo["suicideGrenadeKill"] = 0;
                var_2.explosiveinfo["weapon"] = var_6;
                var_21 = issubstr( var_6, "h1_frag" );

                if ( var_1 != var_2 )
                {
                    if ( ( issubstr( var_6, "c4_" ) || issubstr( var_6, "claymore_" ) ) && isdefined( var_1 ) && isdefined( var_0.owner ) )
                    {
                        var_2.explosiveinfo["returnToSender"] = var_0.owner == var_2;
                        var_2.explosiveinfo["counterKill"] = isdefined( var_0.wasdamaged );
                        var_2.explosiveinfo["chainKill"] = isdefined( var_0.waschained );
                        var_2.explosiveinfo["bulletPenetrationKill"] = isdefined( var_0.wasdamagedfrombulletpenetration );
                        var_2.explosiveinfo["cookedKill"] = 0;
                    }

                    if ( isdefined( var_1.lastgrenadesuicidetime ) && var_1.lastgrenadesuicidetime >= gettime() - 50 && var_21 )
                        var_2.explosiveinfo["suicideGrenadeKill"] = 1;
                }

                if ( var_21 )
                {
                    var_2.explosiveinfo["cookedKill"] = isdefined( var_0.iscooked );
                    var_2.explosiveinfo["throwbackKill"] = isdefined( var_0.threwback );
                }

                var_2.explosiveinfo["stickKill"] = isdefined( var_0.isstuck ) && var_0.isstuck == "enemy";
                var_2.explosiveinfo["stickFriendlyKill"] = isdefined( var_0.isstuck ) && var_0.isstuck == "friendly";
            }

            if ( isplayer( var_1 ) && var_1 != self )
                maps\mp\gametypes\_gamelogic::setinflictorstat( var_0, var_1, var_6 );
        }

        if ( issubstr( var_5, "MOD_IMPACT" ) && 
            (var_6 == "m320_mp"     || 
                issubstr(var_6, "gl")   || 
                issubstr(var_6, "gp25") ||
                var_6 == "h2_semtex_mp")
            )
        {
            if (isplayer(var_1) && var_1 != self && var_1.team != self.team)
            {
                if (var_6 == "h2_semtex_mp" && isplayer(var_2))
                {
                    var_1 thread maps\mp\gametypes\_hud_message::stucksplashnotify( false ); // attacker
                    var_2 thread maps\mp\gametypes\_hud_message::stucksplashnotify( true ); // victim
                }
                else
                {
                    maps\mp\gametypes\_gamelogic::setinflictorstat( var_0, var_1, var_6 );
                }
            }
        }

        if ( isplayer( var_1 ) && isdefined( var_1.pers["participation"] ) )
            var_1.pers["participation"]++;
        else if ( isplayer( var_1 ) )
            var_1.pers["participation"] = 1;

        if ( var_12 )
        {
            if ( level.friendlyfire == 0 || !isplayer( var_1 ) && level.friendlyfire != 1 )
            {
                if ( var_6 == "artillery_mp" )
                    var_2 damageshellshockandrumble( var_0, var_6, var_5, var_3, var_4, var_1 );

                return "friendly fire";
            }
            else if ( level.friendlyfire == 1 )
            {
                if ( var_3 < 1 )
                    var_3 = 1;

                if ( var_2 maps\mp\_utility::isjuggernaut() )
                    var_3 = maps\mp\perks\_perks::cac_modified_damage( var_2, var_1, var_3, var_5, var_6, var_7, var_8, var_9 );

                var_2.lastdamagewasfromenemy = 0;
                var_2 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );
            }
            else if ( level.friendlyfire == 2 && maps\mp\_utility::isreallyalive( var_1 ) )
            {
                var_3 = int( var_3 * 0.5 );

                if ( var_3 < 1 )
                    var_3 = 1;

                var_1.lastdamagewasfromenemy = 0;
                var_1.friendlydamage = 1;
                var_1 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );
                var_1.friendlydamage = undefined;
            }
            else if ( level.friendlyfire == 3 && maps\mp\_utility::isreallyalive( var_1 ) )
            {
                var_3 = int( var_3 * 0.5 );

                if ( var_3 < 1 )
                    var_3 = 1;

                var_2.lastdamagewasfromenemy = 0;
                var_1.lastdamagewasfromenemy = 0;
                var_2 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );

                if ( maps\mp\_utility::isreallyalive( var_1 ) )
                {
                    var_1.friendlydamage = 1;
                    var_1 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );
                    var_1.friendlydamage = undefined;
                }
            }

            var_18 = 1;
        }
        else
        {
            if ( var_3 < 1 )
                var_3 = 1;

            if ( isdefined( var_1 ) && isplayer( var_1 ) )
                addattacker( var_2, var_1, var_0, var_6, var_3, var_7, var_8, var_9, var_10, var_5 );

            if ( isdefined( var_1 ) && !isplayer( var_1 ) && isdefined( var_1.owner ) && ( !isdefined( var_1.scrambled ) || !var_1.scrambled ) )
                addattacker( var_2, var_1.owner, var_0, var_6, var_3, var_7, var_8, var_9, var_10, var_5 );
            else if ( isdefined( var_1 ) && !isplayer( var_1 ) && isdefined( var_1.secondowner ) && isdefined( var_1.scrambled ) && var_1.scrambled )
                addattacker( var_2, var_1.secondowner, var_0, var_6, var_3, var_7, var_8, var_9, var_10, var_5 );

            if ( var_5 == "MOD_EXPLOSIVE" || var_5 == "MOD_GRENADE_SPLASH" && var_3 < var_2.health )
                var_2 notify( "survived_explosion", var_1 );

            if ( isdefined( var_1 ) && isplayer( var_1 ) && isdefined( var_6 ) )
                var_1 thread maps\mp\gametypes\_weapons::checkhit( var_6, var_2 );

            if ( var_2 victimcanupdatefinalattackerdata( var_1 ) )
            {
                var_2.attackerposition = undefined;

                if ( isdefined( var_1 ) && isplayer( var_1 ) && isdefined( var_6 ) && var_1 != var_2 )
                    var_2.attackerposition = var_1.origin;

                if ( issubstr( var_5, "MOD_GRENADE" ) && isdefined( var_0 ) && isdefined( var_0.iscooked ) )
                    var_2.wascooked = gettime();
                else
                    var_2.wascooked = undefined;

                if ( issubstr( var_5, "MOD_IMPACT" ) && isdefined( var_0 ) && isdefined( var_0.recall ) && var_0.recall )
                    var_2.wasrecall = 1;
                else
                    var_2.wasrecall = 0;
            }

            var_2.lastdamagewasfromenemy = isdefined( var_1 ) && var_1 != var_2;

            if ( var_2.lastdamagewasfromenemy )
            {
                var_22 = gettime();
                var_1.damagedplayers[var_2.guid] = var_22;
                var_2.lastdamagedtime = var_22;
            }

            var_2 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );
            var_2 thread maps\mp\gametypes\_missions::playerdamaged( var_0, var_1, var_3, var_5, var_6, var_9 );
        }

        if ( var_3 > 0 && var_5 != "MOD_FALLING" )
            var_2 setclientomnvar( "ui_damage_flash", 1 );

        if ( var_17 && isdefined( var_1.gunner ) )
            var_23 = var_1.gunner;
        else
            var_23 = var_1;

        if ( isdefined( var_23 ) && ( var_23 != var_2 || maps\mp\_utility::iskillstreakweapon( var_6 ) ) && var_3 > 0 && ( !isdefined( var_9 ) || var_9 != "shield" ) )
        {
            if ( isDefined( var_1 ) && isDefined( var_1.disableDamageFeedback ) && var_1.disableDamageFeedback )
                var_24 = "none";
            if ( !maps\mp\_utility::isreallyalive( var_2 ) )
                var_24 = "killshot";
            else if ( var_4 & level.idflags_stun )
                var_24 = "stun";
            else if ( isdefined( var_2.exo_health_on ) && var_2.exo_health_on == 1 )
                var_24 = "hitmorehealth";
            else if ( var_2 maps\mp\_utility::_hasperk( "specialty_armorvest" ) )
                var_24 = "hitmorehealth";
            else if ( isexplosivedamagemod( var_5 ) && isDefined( var_2.blastShielded ) )
                var_24 = "hitblastshield";
            else if ( isdefined( var_2.lightarmorhp ) && var_5 != "MOD_HEAD_SHOT" && !maps\mp\_utility::isfmjdamage( var_6, var_5, var_1 ) )
                var_24 = "hitlightarmor";
            else if ( var_2 maps\mp\_utility::_hasperk( "specialty_combathigh" ) )
                var_24 = "hitpainkiller";
            else if ( var_2 maps\mp\_utility::isjuggernaut() )
                var_24 = "hitjuggernaut";
            else if ( !shouldweaponfeedback( var_6 ) )
                var_24 = "none";
            else if ( isdefined( var_2.exo_health_on ) && var_2.exo_health_on )
                var_24 = "hitjuggernaut";
            else
                var_24 = "standard";

            var_23 thread maps\mp\gametypes\_damagefeedback::updatedamagefeedback( var_24 );
        }

        maps\mp\gametypes\_gamelogic::sethasdonecombat( var_2, 1 );
    }

    if ( isdefined( var_1 ) && var_1 != var_2 && !var_18 )
        level.usestartspawns = 0;

    if ( var_2.sessionstate != "dead" )
    {
        var_25 = var_2 getentitynumber();
        var_26 = var_2.name;
        var_27 = var_2.pers["team"];
        var_28 = var_2.guid;
        var_29 = "";

        if ( isplayer( var_1 ) )
        {
            var_30 = var_1 getentitynumber();
            var_31 = var_1.guid;
            var_32 = var_1.name;
            var_29 = var_1.pers["team"];
        }
        else
        {
            var_30 = -1;
            var_31 = "";
            var_32 = "";
            var_29 = "world";
        }

        if ( isplayer( var_1 ) )
        {
            var_33 = var_1.name;
            var_34 = var_1.origin;
            var_35 = var_1.lifeid;
        }
        else
        {
            var_33 = "world";
            var_34 = var_2.origin;
            var_35 = -1;
        }

        var_36 = gettime();

        if ( !isagent( var_2 ) && isdefined( var_2.spawninfo ) && isdefined( var_2.spawninfo.spawntime ) )
        {
            var_37 = ( var_36 - var_2.spawninfo.spawntime ) / 1000.0;

            if ( var_37 <= 3.0 && var_2.spawninfo.damagereceivedtoofast == 0 )
            {
                if ( !isdefined( level.matchdata ) )
                    level.matchdata = [];

                if ( !isdefined( level.matchdata["badSpawnDmgReceivedCount"] ) )
                    level.matchdata["badSpawnDmgReceivedCount"] = 1;
                else
                    level.matchdata["badSpawnDmgReceivedCount"]++;

                var_2.spawninfo.damagereceivedtoofast = 1;

                if ( var_2.spawninfo.badspawn == 0 )
                {
                    if ( !isdefined( level.matchdata["badSpawnByAnyMeansCount"] ) )
                        level.matchdata["badSpawnByAnyMeansCount"] = 1;
                    else
                        level.matchdata["badSpawnByAnyMeansCount"]++;

                    var_2.spawninfo.badspawn = 1;
                }
            }
        }
        else
            var_37 = -1;

        if ( isdefined( var_1 ) && isdefined( var_1.spawninfo ) && isdefined( var_1.spawninfo.spawntime ) && isplayer( var_1 ) )
        {
            var_38 = ( var_36 - var_1.spawninfo.spawntime ) / 1000.0;

            if ( var_38 <= 3.0 && var_1.spawninfo.damagedealttoofast == 0 )
            {
                if ( !isdefined( level.matchdata ) )
                    level.matchdata = [];

                if ( !isdefined( level.matchdata["badSpawnDmgDealtCount"] ) )
                    level.matchdata["badSpawnDmgDealtCount"] = 1;
                else
                    level.matchdata["badSpawnDmgDealtCount"]++;

                var_1.spawninfo.damagedealttoofast = 1;

                if ( var_1.spawninfo.badspawn == 0 )
                {
                    if ( !isdefined( level.matchdata["badSpawnByAnyMeansCount"] ) )
                        level.matchdata["badSpawnByAnyMeansCount"] = 1;
                    else
                        level.matchdata["badSpawnByAnyMeansCount"]++;

                    var_1.spawninfo.badspawn = 1;
                }
            }
        }
        else
            var_38 = -1;

        if ( !isagent( var_2 ) )
            reconspatialevent( var_2.origin, "script_mp_damage: player_name %s, player_angles %v, hit_loc %s, attacker_name %s, attacker_pos %v, damage %d, weapon %s, damage_type %s, gameTime %d, life_id %d, attacker_life_id %d, spawnToDamageReceivedTime %f, spawnToDamageDealtTime %f", var_2.name, var_2.angles, var_9, var_33, var_34, var_3, var_6, var_5, var_36, var_2.lifeid, var_35, var_37, var_38 );

        logprint( "D;" + var_28 + ";" + var_25 + ";" + var_27 + ";" + sanitise_name( var_26 ) + ";" + var_31 + ";" + var_30 + ";" + var_29 + ";" + var_32 + ";" + var_6 + ";" + var_3 + ";" + var_5 + ";" + var_9 + "\n" );
    }

    hitlocdebug( var_1, var_2, var_3, var_9, var_4 );

    if ( isagent( self ) )
        self [[ maps\mp\agents\_agent_utility::agentfunc( "on_damaged_finished" ) ]]( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10 );

    return "finished";
}

hz_playerkilled_internal( var_0,     var_1,    var_2,  var_3,   var_4,         var_5,   var_6, var_7,  var_8,        var_9,             var_10, var_11 )
{
                    //eInflictor, attacker, victim, iDamage, sMeansOfDeath, sWeapon, vDir, sHitLoc, psOffsetTime, deathAnimDuration, isFauxDeath
    var_2 endon( "spawned" );
    var_2 notify( "killed_player" );

    if((var_4 == "MOD_TRIGGER_HURT" || var_4 == "MOD_SUICIDE") && var_2.team == "axis"){
		var_2.money -= 25;
		var_2 thread user_scripts\mp_patches\hawkins\hud::scorePopup( -25, 0, (25.5, 0, 0), 1 );
	}
	else {
		if(var_1.team == "axis" && var_2.team == "allies" ){
			if(isDefined(var_1.owner)){
                    var_1.owner.money += 150;
				    var_1.owner thread user_scripts\mp_patches\hawkins\hud::scorePopup( 150, 0, (25.5, 25.5, 3.6), 1 ); 
                }
                else{
                    var_1.money += 150;
				    var_1 thread user_scripts\mp_patches\hawkins\hud::scorePopup( 150, 0, (25.5, 25.5, 3.6), 1 ); 
                }
		}
		if(var_2.team == "axis" && var_1.team == "allies"){
            if(isDefined(var_2.owner)){
                    var_2.owner.money += 50;
				    var_2.owner thread user_scripts\mp_patches\hawkins\hud::scorePopup( 50, 0, (25.5, 25.5, 3.6), 1 ); 
                }
                else{
                    var_2.money += 50;
				    var_2 thread user_scripts\mp_patches\hawkins\hud::scorePopup( 50, 0, (25.5, 25.5, 3.6), 1 ); 
                }
		}
		if(var_1.team == "allies" && var_2.team == "axis" ){
			if(var_7 == "head"){
                if(isDefined(var_1.owner)){
                    var_1.owner.money += 75;
				    var_1.owner thread user_scripts\mp_patches\hawkins\hud::scorePopup( 75, 0, (25.5, 25.5, 3.6), 1 ); 
                }
                else{
                    var_1.money += 75;
				    var_1 thread user_scripts\mp_patches\hawkins\hud::scorePopup( 75, 0, (25.5, 25.5, 3.6), 1 ); 
                }
			}	
			else{
				if(isDefined(var_1.owner)){
                    var_1.owner.money += 50;
				    var_1.owner thread user_scripts\mp_patches\hawkins\hud::scorePopup( 50, 0, (25.5, 25.5, 3.6), 1 ); 
                }
                else{
                    var_1.money += 50;
				    var_1 thread user_scripts\mp_patches\hawkins\hud::scorePopup( 50, 0, (25.5, 25.5, 3.6), 1 ); 
                }
			}
			level.zKills++;	
		}
	}

    if(var_2.team == "axis" && self.zombieSkills["flying"] == 1){
        if(self.flyingLives > 1)
            self.flyingLives--;
        else{
            self.flyingLives = 0;
            self.zombieSkills["flying"] = 0;
            self notify("flying_over");
        }
    }

    if ( isdefined( var_2.prekilledfunc ) )
        var_2 [[ var_2.prekilledfunc ]]( var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10 );

    var_2 maps\mp\gametypes\_playerlogic::resetuidvarsondeath();
    var_2.abilitychosen = 0;
    var_2.perkoutlined = 0;
    var_2.sensoroutlined = 0;
    var_1 = maps\mp\_utility::_validateattacker( var_1 );

    if ( isdefined( var_1 ) )
        var_1.assistedsuicide = undefined;

    if( isDefined( var_0 ) && isDefined( var_0.script_dog ) )
        var_0.killedPlayer = true;

    if ( !isdefined( var_2.idflags ) )
    {
        if ( var_4 == "MOD_SUICIDE" )
            var_2.idflags = 0;
        else if ( var_4 == "MOD_GRENADE" && ( issubstr( var_5, "fraggrenade" ) || issubstr( var_5, "thermobaric_grenade" ) ) && var_3 == 100000 )
            var_2.idflags = 0;
        else if ( level.friendlyfire >= 2 )
            var_2.idflags = 0;
        else
        {

        }
    }

    var_18 = maps\mp\_utility::ismeleemod( var_4 ) && ( issubstr( var_5, "knife" ) || issubstr( var_5, "tactical" ) );

    if ( var_18 )
    {
        if ( isdefined( common_scripts\utility::getfx( "exo_knife_blood" ) ) )
        {
            if ( isdefined( var_7 ) && isdefined( var_6 ) && isdefined( gethitloctag( var_7 ) ) )
                playimpactheadfatalfx( var_2 gettagorigin( gethitloctag( var_7 ) ), var_6 );
            else
                playimpactheadfatalfx( var_2 gettagorigin( "j_neck" ), anglestoforward( var_2 gettagangles( "j_neck" ) ) );
        }
    }

    maps\mp\gametypes\_weapons::recordtogglescopestates();

    if ( !var_10 )
    {
        if ( isdefined( var_2.endgame ) )
            maps\mp\_utility::revertvisionsetforplayer( 2 );
        else
        {
            maps\mp\_utility::revertvisionsetforplayer( 0 );
            var_2 thermalvisionoff();
        }
    }
    else
    {
        var_2.fauxdead = 1;
        self notify( "death", var_1, var_4, var_5 );
    }

    if ( game["state"] == "postgame" )
        return;

    var_19 = 0;

    if ( !isplayer( var_0 ) && isdefined( var_0.primaryweapon ) )
        var_20 = var_0.primaryweapon;
    else if ( isdefined( var_1 ) && isplayer( var_1 ) && var_1 getcurrentprimaryweapon() != "none" )
        var_20 = var_1 getcurrentprimaryweapon();
    else if ( issubstr( var_5, "alt_" ) )
        var_20 = getsubstr( var_5, 4, var_5.size );
    else
        var_20 = undefined;

    if ( isdefined( var_2.uselaststandparams ) )
    {
        var_2.uselaststandparams = undefined;
        var_2 ensurelaststandparamsvalidity();
        var_21 = var_1 == var_2;
        var_0 = var_2.laststandparams.einflictor;
        var_1 = maps\mp\_utility::_validateattacker( var_2.laststandparams.attacker );
        var_3 = var_2.laststandparams.idamage;
        var_4 = var_2.laststandparams.smeansofdeath;
        var_5 = var_2.laststandparams.sweapon;
        var_20 = var_2.laststandparams.sprimaryweapon;
        var_6 = var_2.laststandparams.vdir;
        var_7 = var_2.laststandparams.shitloc;

        if ( var_21 )
            var_19 = ( gettime() - var_2.laststandparams.laststandstarttime ) / 1000;

        var_2.laststandparams = undefined;
    }

    if ( ( !isdefined( var_1 ) || var_1.classname == "trigger_hurt" || var_1.classname == "worldspawn" || var_1 == var_2 ) && isdefined( self.attackers ) )
    {
        var_22 = undefined;

        foreach ( var_24 in self.attackers )
        {
            if ( !isdefined( maps\mp\_utility::_validateattacker( var_24 ) ) )
                continue;

            if ( !isdefined( var_2.attackerdata[var_24.guid].damage ) )
                continue;

            if ( var_24 == var_2 || level.teambased && var_24.team == var_2.team )
                continue;

            if ( var_2.attackerdata[var_24.guid].lasttimedamaged + 2500 < gettime() && ( var_1 != var_2 && ( isdefined( var_2.laststand ) && var_2.laststand ) ) )
                continue;

            if ( var_2.attackerdata[var_24.guid].damage > 1 && !isdefined( var_22 ) )
            {
                var_22 = var_24;
                continue;
            }

            if ( isdefined( var_22 ) && var_2.attackerdata[var_24.guid].damage > var_2.attackerdata[var_22.guid].damage )
                var_22 = var_24;
        }

        if ( isdefined( var_22 ) )
        {
            var_1 = var_22;
            var_1.assistedsuicide = 1;
            var_5 = var_2.attackerdata[var_22.guid].weapon;
            var_6 = var_2.attackerdata[var_22.guid].vdir;
            var_7 = var_2.attackerdata[var_22.guid].shitloc;
            var_8 = var_2.attackerdata[var_22.guid].psoffsettime;
            var_4 = var_2.attackerdata[var_22.guid].smeansofdeath;
            var_3 = var_2.attackerdata[var_22.guid].damage;
            var_20 = var_2.attackerdata[var_22.guid].sprimaryweapon;
            var_0 = var_1;
        }
    }
    else if ( isdefined( var_1 ) )
        var_1.assistedsuicide = undefined;

    if ( maps\mp\_utility::isheadshot( var_5, var_7, var_4, var_1 ) )
        var_4 = "MOD_HEAD_SHOT";
    else if ( !maps\mp\_utility::ismeleemod( var_4 ) && !isdefined( var_2.nuked ) )
        var_2 maps\mp\_utility::playdeathsound();

    var_26 = isfriendlyfire( var_2, var_1 );

    if ( isdefined( var_1 ) )
    {
        if ( var_1.code_classname == "script_vehicle" && isdefined( var_1.owner ) )
            var_1 = var_1.owner;

        if ( var_1.code_classname == "misc_turret" && isdefined( var_1.owner ) )
        {
            if ( isdefined( var_1.vehicle ) )
                var_1.vehicle notify( "killedPlayer", var_2 );

            var_1 = var_1.owner;
        }

        if ( var_1.code_classname == "script_model" && isdefined( var_1.owner ) )
        {
            var_1 = var_1.owner;

            if ( !isfriendlyfire( var_2, var_1 ) && var_1 != var_2 )
                var_1 notify( "crushed_enemy" );
        }
    }

    if ( var_4 != "MOD_SUICIDE" && ( maps\mp\_utility::isaigameparticipant( var_2 ) || maps\mp\_utility::isaigameparticipant( var_1 ) ) && isdefined( level.bot_funcs ) && isdefined( level.bot_funcs["get_attacker_ent"] ) )
    {
        var_27 = [[ level.bot_funcs["get_attacker_ent"] ]]( var_1, var_0 );

        if ( isdefined( var_27 ) )
        {
            if ( maps\mp\_utility::isaigameparticipant( var_2 ) )
                var_2 botmemoryevent( "death", var_5, var_27.origin, var_2.origin, var_27 );

            if ( maps\mp\_utility::isaigameparticipant( var_1 ) )
            {
                var_28 = 1;

                if ( var_27.classname == "script_vehicle" && isdefined( var_27.helitype ) || var_27.classname == "rocket" || var_27.classname == "misc_turret" )
                    var_28 = 0;

                if ( var_28 )
                    var_1 botmemoryevent( "kill", var_5, var_27.origin, var_2.origin, var_2 );
            }
        }
    }

    var_29 = var_2 getcurrentweapon();

    var_2 maps\mp\gametypes\_weapons::dropScavengerForDeath( var_1 );	// must be done before dropWeaponForDeath, since we use some weapon information

    if ( !isdefined( var_2.agentbody ) )
        var_2 thread [[ level.weapondropfunction ]]( var_1, var_4 );
    else
        var_2.agentbody thread [[ level.weapondropfunction ]]( var_1, var_4 );

    if ( !var_10 )
        var_2 maps\mp\_utility::updatesessionstate( "dead" );

    var_30 = isdefined( var_2.fauxdead ) && var_2.fauxdead && isdefined( var_2.switching_teams ) && var_2.switching_teams;

    if ( !var_30 )
        var_2 maps\mp\gametypes\_playerlogic::removefromalivecount();

    if ( !isdefined( var_2.switching_teams ) && !( isdefined( level.iszombiegame ) && level.iszombiegame ) )
    {
        var_31 = var_2;

        if ( isdefined( var_2.commanding_bot ) )
            var_31 = var_2.commanding_bot;

        var_31 maps\mp\_utility::incpersstat( "deaths", 1 );
        var_31.deaths = var_31 maps\mp\_utility::getpersstat( "deaths" );
        var_31 maps\mp\_utility::updatepersratio( "kdRatio", "kills", "deaths" );
        var_31 maps\mp\gametypes\_persistence::statsetchild( "round", "deaths", var_31.deaths );
        var_31 maps\mp\_utility::incplayerstat( "deaths", 1 );
    }

    var_32 = obituary( var_2, var_1, var_5, var_4 );
    var_33 = var_32["weaponIndex"];
    var_34 = var_32["customIndex"];
    var_35 = var_32["isAlternate"];
    var_36 = 0;
    var_2 logprintplayerdeath( self.lifeid, var_1, var_3, var_4, var_5, var_20, var_7 );
    var_2 maps\mp\_matchdata::logplayerlife( 1 );
    var_2 maps\mp\_matchdata::logplayerdeath( self.lifeid, var_1, var_3, var_4, var_5, var_20, var_7, var_29 );

    if ( maps\mp\_utility::ismeleemod( var_4 ) && isplayer( var_1 ) && !issubstr( var_5, "riotshield" ) )
    {
        var_1 maps\mp\_utility::incplayerstat( "knifekills", 1 );
        var_1 _meth_8580();
        var_1.meleeweaponbloodytime = gettime();
    }

    if ( var_2 isswitchingteams() )
        handleteamchangedeath();
    else if ( !isplayer( var_1 ) || isplayer( var_1 ) && var_4 == "MOD_FALLING" )
    {
        handleworlddeath( var_1, self.lifeid, var_4, var_7 );

        if ( isagent( var_1 ) )
            var_36 = 1;
    }
    else if ( var_1 == var_2 && ( isdefined( var_0 ) && ( !isdefined( var_0.isorbitalcam ) || var_0.isorbitalcam == 0 ) ) )
        handlesuicidedeath( var_4, var_7 );
    else if ( var_26 )
    {
        if ( !isdefined( var_2.nuked ) )
            handlefriendlyfiredeath( var_1 );
    }
    else
    {
        if ( var_4 == "MOD_GRENADE" && var_0 == var_1 || var_4 == "MOD_IMPACT" || var_4 == "MOD_GRENADE_SPLASH" || var_4 == "MOD_EXPLOSIVE" )
            addattacker( var_2, var_1, var_0, var_5, var_3, ( 0.0, 0.0, 0.0 ), var_6, var_7, var_8, var_4 );

        var_36 = 1;

        if ( isai( var_2 ) && isdefined( level.bot_funcs ) && isdefined( level.bot_funcs["should_do_killcam"] ) )
            var_36 = var_2 [[ level.bot_funcs["should_do_killcam"] ]]();
        else if ( istestclient( var_2 ) )
            var_36 = 0;

        if ( isdefined( var_0 ) )
        {
            handlenormaldeath( self.lifeid, var_1, var_0, var_5, var_4 );
            var_2 thread maps\mp\gametypes\_missions::playerkilled( var_0, var_1, var_3, var_4, var_5, var_20, var_7, var_1.modifiers, var_11 );
        }
        else
        {
            if (var_4 == "MOD_GRENADE" || var_4 == "MOD_GRENADE_SPLASH" || var_4 == "MOD_EXPLOSIVE")
            {
                if (var_2 != var_1)
                {
                    handlenormaldeath( self.lifeid, var_1, var_1, var_5, var_4 );
                    var_2 thread maps\mp\gametypes\_missions::playerkilled( var_1, var_1, var_3, var_4, var_5, var_20, var_7, var_1.modifiers, var_11 );
                }
            }
        }

        var_2.pers["cur_death_streak"]++;

        if ( isplayer( var_1 ) && var_2 maps\mp\_utility::isjuggernaut() )
            var_1 thread maps\mp\_utility::teamplayercardsplash( "callout_killed_juggernaut", var_1 );
    }

    var_37 = 0;
    var_38 = undefined;

    if ( isdefined( self.previousprimary ) )
    {
        var_37 = 1;
        var_38 = self.previousprimary;
        self.previousprimary = undefined;
    }

    if ( isplayer( var_1 ) && var_1 != self && ( !level.teambased || level.teambased && self.team != var_1.team ) )
    {
        if ( var_37 && isdefined( var_38 ) )
            var_39 = var_38;
        else
            var_39 = self.lastdroppableweapon;

        if ( !var_11 )
            thread maps\mp\gametypes\_gamelogic::trackleaderboarddeathstats( var_39, var_4 );

        var_1 thread maps\mp\gametypes\_gamelogic::trackattackerleaderboarddeathstats( var_5, var_4, var_0 );
    }

    var_2.wasswitchingteamsforonplayerkilled = undefined;

    if ( isdefined( var_2.switching_teams ) )
        var_2.wasswitchingteamsforonplayerkilled = 1;

    var_2 resetplayervariables();
    var_2.lastattacker = var_1;
    var_2.lastinflictor = var_0;

    if ( !isdefined( var_2.agentbody ) )
        var_2.lastdeathpos = var_2.origin;
    else
        var_2.lastdeathpos = var_2.agentbody.origin;

    var_2.deathtime = gettime();
    var_2.wantsafespawn = 0;
    var_2.revived = 0;
    var_2.sameshotdamage = 0;
    var_40 = maps\mp\_awards::gettotalscore( var_2 ) - var_2.scoreatlifestart;
    var_2 maps\mp\_utility::setplayerstatifgreater( "mostScorePerLife", var_40 );
    var_41 = undefined;

    if ( maps\mp\_utility::isrocketcorpse() )
    {
        var_36 = 1;
        var_10 = 0;
        var_41 = self.killcament;
        self waittill( "final_rocket_corpse_death" );
    }
    else
    {
        if ( var_10 )
        {
            var_36 = 0;

            if ( !isdefined( var_2.agentbody ) )
                var_9 = var_2 playerforcedeathanim( var_0, var_4, var_5, var_7, var_6 );
        }

        if ( var_11 )
        {
            var_36 = 0;
            thread maps\mp\gametypes\_deathicons::adddeathicon( var_2, var_2, var_2.team, 5.0, var_1, 1 );
        }
        else if ( isdefined( var_2.hideondeath ) && var_2.hideondeath )
        {
            var_2 playerhide();
            thread maps\mp\gametypes\_deathicons::adddeathicon( var_2, var_2, var_2.team, 5.0, var_1, 0 );
        }
        else if ( !isdefined( var_2.agentbody ) )
        {
            var_2.body = var_2 cloneplayer( var_9, var_2.lastdroppableweapon );

            if ( var_10 )
                var_2 playerhide();

            if ( var_2 isonladder() || var_2 ismantling() || !var_2 isonground() || isdefined( var_2.nuked ) )
                var_2.body startragdoll();

            if ( !isdefined( var_2.switching_teams ) )
                thread maps\mp\gametypes\_deathicons::adddeathicon( var_2.body, var_2, var_2.team, 5.0, var_1, 0 );

            thread delaystartragdoll( var_2.body, var_7, var_6, var_5, var_0, var_4 );
        }
        else if ( !isdefined( var_2.switching_teams ) )
            thread maps\mp\gametypes\_deathicons::adddeathicon( var_2.agentbody, var_2, var_2.team, 5.0, var_1, 0 );
    }

    var_2 thread [[ level.onplayerkilled ]]( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, self.lifeid );

    //var_0,     var_1,    var_2,  var_3,   var_4,         var_5,   var_6, var_7,  var_8,        var_9,             var_10, var_11 )
    //eInflictor, attacker, victim, iDamage, sMeansOfDeath, sWeapon, vDir, sHitLoc, psOffsetTime, deathAnimDuration, isFauxDeath

    players = maps\mp\gametypes\_teams::CountPlayers();
	if(level.gameState == "playing")
	{
		if(var_2.team=="allies")
		{
			if(players["allies"] == 0){
				level.endGameKill = true;
				level notify("endGameKill");
				level.gameState = "ending";
				level thread user_scripts\mp_patches\hawkins\init::doEnding();
			}
			else{
				var_2 user_scripts\mp_patches\hawkins\setup::resetVariables();
				//var_2 thread user_scripts\mp_patches\hawkins\utilities::ResetPerks();
				var_2 user_scripts\mp_patches\hawkins\utils::ResetAllScores();
                var_2.pers["class"] = "class3";
			    var_2.class = var_2.pers["class"];
				var_2.HawkinZombie = true;
				var_2.ck = var_2.kills;
				var_2.cd = var_2.deaths;
				var_2.cs = var_2.suicides;
				var_2 maps\mp\gametypes\_menus::addToTeam( "axis" );
                var_2.team = "axis";
			}
		}
	}

    if ( isai( var_2 ) && isdefined( level.bot_funcs ) && isdefined( level.bot_funcs["on_killed"] ) )
        var_2 thread [[ level.bot_funcs["on_killed"] ]]( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, self.lifeid );

    if ( maps\mp\_utility::isgameparticipant( var_1 ) )
        var_42 = var_1 getentitynumber();
    else
        var_42 = -1;

    if ( !isdefined( var_41 ) && isdefined( var_1 ) )
        var_41 = var_2 getkillcamentity( var_1, var_0, var_5 );

    var_43 = -1;
    var_44 = 0;
    var_45 = 0;

    if ( isdefined( var_41 ) )
    {
        var_43 = var_41 getentitynumber();
        var_44 = var_41.birthtime;

        if ( isdefined( var_41.killcamstarttime ) )
        {
            var_44 = var_41.killcamstarttime;
            var_45 = 1;
        }

        if ( !isdefined( var_44 ) )
            var_44 = 0;
    }

    if ( isdefined( var_1 ) && isdefined( var_1.lastspawntime ) )
        var_46 = ( gettime() - var_1.lastspawntime ) / 1000.0;
    else
        var_46 = 0;

    is_victim_the_attacker = ( (isdefined(var_1) && isplayer(var_1)) && var_2 == var_1 );

    if (is_victim_the_attacker == false && var_4 != "MOD_SUICIDE" && !( !isdefined( var_1 ) || var_1.classname == "trigger_hurt" || var_1.classname == "worldspawn" || var_1 == var_2 ) )
        recordfinalkillcam( 5.0, var_2, var_1, var_42, var_43, var_44, var_5, var_33, var_34, var_35, var_19, var_8, var_4, "normal", var_45 );

    if ( is_victim_the_attacker == false && maps\mp\gametypes\_killcam::killcamvalid( var_2, var_36 ) )
    {
        var_47 = maps\mp\gametypes\_playerlogic::timeuntilspawn( 1 );
        var_48 = maps\mp\gametypes\_gamelogic::timeuntilroundend();
        var_49 = maps\mp\gametypes\_killcam::killcamtime( var_44, var_5, 0, var_47, var_48, var_45, 0 );
        var_46 = maps\mp\gametypes\_killcam::killcamadjustalivetime( var_46, var_42, var_43 );
        var_50 = maps\mp\gametypes\_killcam::killcamarchivetime( var_49, var_46, var_19, var_8 / 1000 );
        var_2 maps\mp\gametypes\_killcam::prekillcamnotify( var_0, var_1, var_50, var_29 );
    }
    else if ( maps\mp\_utility::isvalidclass( var_2.class ) && !var_11 )
        var_2 maps\mp\gametypes\_playerlogic::streamclass();

    var_51 = gettime() + 5000;

    if ( !var_10 && !var_11 )
    {
        var_52 = var_2 maps\mp\gametypes\_playerlogic::getrespawndelay() > 0;
        var_53 = !( maps\mp\_utility::getgametypenumlives() && !var_2.pers["lives"] );

        if ( var_52 || !var_53 )
            var_2 maps\mp\_utility::streamnextspectatorweaponsifnecessary( 1 );

        wait 0.25;
        var_2 thread maps\mp\gametypes\_killcam::cancelkillcamonuse();

        if ( !maps\mp\_utility::is_true( level.movecompareactive ) )
        {
            wait 0.25;
            self.respawntimerstarttime = gettime() + 1000;
            var_47 = maps\mp\gametypes\_playerlogic::timeuntilspawn( 1 );

            if ( var_47 < 1 )
                var_47 = 1;

            wait 1.0;
        }

        if ( isdefined( self.killcamstream ) )
        {
            while ( is_victim_the_attacker == false && maps\mp\gametypes\_killcam::killcamvalid( var_2, var_36 ) && isplayer( self ) && isplayer( var_1 ) && !self hasloadedcustomizationplayerview( self.killcamstream.cust, self.killcamstream.weapons ) && gettime() < var_51 )
                waitframe();
        }

        var_2 notify( "death_delay_finished" );
    }

    var_54 = ( gettime() - var_2.deathtime ) / 1000;
    self.respawntimerstarttime = gettime();
    var_55 = gettime() >= var_51;

    if ( is_victim_the_attacker == false && maps\mp\gametypes\_killcam::killcamvalid( var_2, var_36 ) && !var_55 )
    {
        var_53 = !( maps\mp\_utility::getgametypenumlives() && !var_2.pers["lives"] );
        var_47 = maps\mp\gametypes\_playerlogic::timeuntilspawn( 1 );
        var_60 = var_53 && var_47 <= 0;

        if ( !var_53 )
        {
            var_47 = -1;
            level notify( "player_eliminated", var_2 );
        }

        if( var_2 maps\mp\_utility::isEMPed() )
            var_2 maps\mp\h2_killstreaks\_emp::_setEMPJammed( false );

        var_2 maps\mp\gametypes\_killcam::killcam( var_0, var_42, var_43, var_44, var_5, var_33, var_34, var_35, var_54 + var_19, var_8, var_47, var_60, maps\mp\gametypes\_gamelogic::timeuntilroundend(), var_1, var_2, var_4, "normal", var_46, var_45 );
    }

    if ( game["state"] != "playing" )
    {
        if ( !level.showingfinalkillcam )
        {
            var_2 maps\mp\_utility::updatesessionstate( "dead" );
            var_2 maps\mp\_utility::clearkillcamstate();
        }

        return;
    }

    var_61 = maps\mp\_utility::getgametypenumlives();
    var_62 = self.pers["lives"];

    if ( !var_11 && maps\mp\_utility::isvalidclass( var_2.class ) )
        var_2 thread maps\mp\gametypes\_playerlogic::spawnclient();
}